﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using MySql.Data.MySqlClient;
using System.Data;
using System.Windows.Forms;
using System.Runtime.CompilerServices;
using System.Web;



namespace Percent___Qualification_work.Classes
{
    public class databaseConnection
    {
        private MySqlConnection connection;
        private string connectionString = "server=localhost;database=PerCent;user=root;password=";

        public databaseConnection()
        {
            connection = new MySqlConnection(connectionString);
        }

        public bool openConnection()
        {
            try
            {
                connection.Open();
                return true;
            }
            catch (MySqlException ex)
            {
                MessageBox.Show("Connection error : " + ex.Message);
                return false;
            }
        }

        public bool closeConnection()
        {
            try
            {
                connection.Close();
                return true;
            }
            catch (MySqlException ex)
            {
                MessageBox.Show("Closing connection error: " + ex.Message);
                return false;
            }
        }

        public DataTable ExecuteQuery(string query)
        {
            DataTable dataTable = new DataTable();

            try
            {
                if (openConnection())
                {
                    MySqlCommand cmd = new MySqlCommand(query, connection);
                    MySqlDataAdapter adapter = new MySqlDataAdapter(cmd);
                    adapter.Fill(dataTable);
                    closeConnection();
                }
            }
            catch (MySqlException ex)
            {
                MessageBox.Show("Query error: " + ex.Message);
            }

            return dataTable;
        }

        //DATABASE QUERIES


        //SIGN UP QUERY
        public bool AddUser(string username, string hashedPassword)
        {
            //query to insert user data into database
            string query = $"INSERT INTO users (username,password) VALUES (@username, @password)";

            try
            {
                //check if connection was established
                if (openConnection())
                {
                    MySqlCommand cmd = new MySqlCommand(query, connection);
                    cmd.Parameters.AddWithValue("@username", username);
                    cmd.Parameters.AddWithValue("@password", hashedPassword);
                    cmd.ExecuteNonQuery();
                    closeConnection();
                    return true;
                }
                return false;
            }
            //checks for errors
            catch (MySqlException ex)
            {
                MessageBox.Show("Database error: " + ex.Message);
                return false;
            }
        }


        public string GetPasswordForUser(string username)
        {
            string query = "SELECT password from users WHERE username = @username";
            try
            {
                if (openConnection())
                {
                    MySqlCommand cmd = new MySqlCommand(query, connection);
                    cmd.Parameters.AddWithValue("@username", username);
                    MySqlDataReader reader = cmd.ExecuteReader();

                    if (reader.Read())
                    {
                        string hashedPassword = reader["password"].ToString();
                        closeConnection();
                        return hashedPassword;
                    }
                    closeConnection();
                    return null;
                }
                return null;
            }
            catch (MySqlException ex)
            {
                MessageBox.Show("Query error: " + ex.Message);
                return null;
            }
        }

        public bool IsUsernameTaken(string username)
        {
            string query = "SELECT COUNT(*) FROM users WHERE username = @username";
            try
            {
                if (openConnection())
                {
                    MySqlCommand cmd = new MySqlCommand(query, connection);
                    cmd.Parameters.AddWithValue("@username", username);
                    int userCount = Convert.ToInt32(cmd.ExecuteScalar());
                    closeConnection();
                    return userCount > 0;
                }
                return false;
            }
            catch (MySqlException ex)
            {
                MessageBox.Show("Query error: " + ex.Message);
                return false;
            }
        }


    }
}
